
//Chris' WinGlide enhancements
//Copr. 1998, Chris Dohnal (cwdohnal@ucdavis.edu)

#ifndef _GAMMADLG_
#define _GAMMADLG_

#include <windows.h>

#define PWM_CLOSE_GAMMA_DIALOG	WM_USER + 128
#define PWM_FOCUS_GAMMA_DIALOG	WM_USER + 129

struct GammaDialogThreadParameters_t {
	HWND hParentWnd;
	RECT parentRect;
};

struct GammaDialogStateInfo_t {
	DWORD dwRedGamma100, dwGreenGamma100, dwBlueGamma100;
};

struct GammaDialogExchange_t {
	BOOL bDialogWasDestroyed;
	BOOL bContainsUpdatedGamma;
	DWORD dwRedGamma100;
	DWORD dwGreenGamma100;
	DWORD dwBlueGamma100;
};


extern BOOL ShowWinGlideGammaDialog(HWND, float, float, float);
extern VOID DestroyWinGlideGammaDialog(VOID);

extern BOOL EnterGammaDialogCriticalSection(VOID);
extern VOID LeaveGammaDialogCriticalSection(VOID);

extern volatile struct GammaDialogExchange_t gGammaDialogExchange;

extern VOID ResetGammaDialogExchangeData(VOID);
extern BOOL CheckForNewGammaCorrectionValues(float *, float *, float *);

#endif //_GAMMADLG_
